@extends('admin.layouts.app')

@section('title', 'Hitung Gaji Harian')

@section('content')
<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0">Hitung Gaji Harian Karyawan</h4>

        <a href="{{ route('admin.gaji.index') }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left me-1"></i> Kembali
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif


    <form action="{{ route('admin.gaji.hitung') }}" method="POST" class="card p-4 shadow-sm">
        @csrf

        <div class="row mb-3">
            <div class="col-md-4">
                <label class="form-label">Karyawan</label>
                <select name="karyawan_id" class="form-select" required>
                    <option value="">-- Pilih Karyawan --</option>
                    @foreach($karyawan as $k)
                        <option value="{{ $k->id }}">
                            {{ $k->user->nama}} - {{ $k->jabatan->nama_jabatan }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">Bulan</label>
<select name="bulan" class="form-select" required>
    @foreach(range(1,12) as $b)
        <option value="{{ $b }}">
            {{ \Carbon\Carbon::create()->month($b)->locale('id')->monthName }}
        </option>
    @endforeach
</select>

            </div>

            <div class="col-md-4">
                <label class="form-label">Tahun</label>
<input type="number" name="tahun"
       value="{{ now('Asia/Jakarta')->year }}"
       class="form-control" required>

            </div>
        </div>

        <button class="btn btn-primary">
            <i class="fas fa-calculator"></i> Hitung Gaji
        </button>
    </form>
</div>
@endsection
